# Zyvra AI Voice Assistant - Design Guidelines

## Design Approach

**System Selection**: Tailwind CSS with shadcn/ui components  
**Rationale**: Enterprise SaaS platform requiring consistent, accessible UI patterns with robust data visualization capabilities. The provided spec already establishes dark-mode-first aesthetic with indigo-cyan gradient accents.

**Core Principles**:
- **Data clarity**: Information hierarchy optimized for quick scanning of metrics and KPIs
- **Professional confidence**: Enterprise-grade polish with sophisticated dark theme
- **Operational efficiency**: Layouts designed for frequent, task-oriented workflows

---

## Typography System

**Font Stack**: Inter (via Google Fonts CDN)
```
Primary: 'Inter', system-ui, -apple-system, sans-serif
Monospace: 'JetBrains Mono', 'Courier New', monospace (for API keys, code)
```

**Type Scale**:
- **Hero/Display**: text-5xl (48px) font-bold tracking-tight
- **Page Titles**: text-3xl (30px) font-bold
- **Section Headers**: text-2xl (24px) font-semibold
- **Card Titles**: text-lg (18px) font-semibold
- **Body**: text-base (16px) font-normal
- **Metadata/Captions**: text-sm (14px) font-medium text-slate-400
- **Micro-labels**: text-xs (12px) font-medium uppercase tracking-wide text-slate-500

**Weight Distribution**: Use font-normal (400) for body, font-medium (500) for labels, font-semibold (600) for headings, font-bold (700) for emphasis.

---

## Layout & Spacing System

**Tailwind Units**: Standardize on **4, 6, 8, 12, 16, 24** for consistent rhythm
- Tight spacing: p-4, gap-4 (component internals)
- Standard spacing: p-6, gap-6 (card padding, form groups)
- Section spacing: py-12, py-16 (between dashboard sections)
- Page margins: px-8 lg:px-12 (main content areas)

**Grid Patterns**:
- **Dashboard KPIs**: grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6
- **Cards/Features**: grid-cols-1 lg:grid-cols-2 xl:grid-cols-3 gap-6
- **Data Tables**: Full-width with horizontal scroll on mobile

**Container Strategy**:
- Sidebar: fixed w-64 (256px)
- Main content: ml-64 with max-w-7xl mx-auto px-8
- Forms: max-w-2xl for optimal readability
- Marketing sections: max-w-6xl mx-auto

---

## Component Library

### Navigation
**Sidebar**: bg-slate-900 fixed h-screen w-64, icons from Lucide (Shield, Phone, Users, BarChart3, Settings), active state: bg-indigo-600/10 border-l-2 border-indigo-500

**Top Bar**: Sticky header with page title (text-2xl font-bold), breadcrumbs (text-sm text-slate-400), user avatar dropdown (right-aligned)

### Cards & Surfaces
**Base Card**: bg-slate-900/50 border border-slate-800 rounded-lg p-6 backdrop-blur-sm  
**Stat Card**: Includes icon circle (bg-indigo-600/10 text-indigo-400), label (text-sm text-slate-400), value (text-3xl font-bold), change indicator (+/- with colors)  
**Chart Card**: p-6 with title bar, filter dropdown, chart container (min-h-80)

### Forms
**Input**: bg-slate-950 border border-slate-800 focus:border-indigo-500 focus:ring-1 focus:ring-indigo-500 rounded-md px-4 py-2.5  
**Button Primary**: bg-gradient-to-r from-indigo-600 to-cyan-600 hover:from-indigo-500 hover:to-cyan-500 px-6 py-2.5 rounded-md font-medium  
**Button Secondary**: bg-slate-800 hover:bg-slate-700 border border-slate-700  
**Button Danger**: bg-red-600 hover:bg-red-500

### Data Display
**Tables**: Striped rows (even:bg-slate-900/30), sticky header, hover:bg-slate-800/50, cell padding: px-4 py-3  
**Badges**: Rounded-full px-3 py-1 text-xs font-medium with status colors (green-500 success, yellow-500 warning, red-500 error)  
**Charts**: Recharts with custom theme: indigo-500 (primary), cyan-500 (secondary), slate-700 (grid), slate-400 (text)

### Overlays
**Modals**: bg-slate-900 border border-slate-800 rounded-lg shadow-2xl max-w-2xl, backdrop: bg-black/60 backdrop-blur-sm  
**Toasts**: Fixed top-right, bg-slate-900 border-l-4 (border-color by type), rounded-md shadow-lg, auto-dismiss 5s

---

## Images

**Hero Section** (Marketing Home Page):  
Full-width hero with gradient overlay. Image: Abstract visualization of voice waveforms, AI neural networks, or customer service dashboard mockup. Overlay: bg-gradient-to-r from-slate-950/95 via-slate-950/80 to-transparent. Place CTA buttons with backdrop-blur-md bg-white/10 treatment.

**Feature Cards** (Marketing Features Page):  
Icon-led cards without images. Use large Lucide icons (size-12) with gradient bg circles.

**Pricing Page**:  
No images. Focus on clear tier comparison table with highlighted recommended plan.

**Dashboard Pages**:  
No decorative images. Charts, metrics, and data visualizations only.

**Contact/About**:  
Optional: Team photo or office environment image at 50% width, right-aligned with text-wrap.

---

## Accessibility & Polish

- All interactive elements have focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 focus:ring-offset-slate-950
- Color contrast meets WCAG AA (test with slate-400 on slate-950)
- Loading states: Skeleton screens with animate-pulse on bg-slate-800/30
- Transitions: transition-all duration-200 ease-in-out for interactive elements
- Empty states: Centered content with muted icon, descriptive text, and primary action button