import { Link } from "wouter";
import PublicLayout from "@/components/PublicLayout";
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardFooter, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { Check } from "lucide-react";

export default function Pricing() {
  const plans = [
    {
      name: "Starter",
      price: "$49",
      perCall: "$0.08",
      limit: "500 calls/month",
      features: [
        "Up to 500 calls per month",
        "Real-time transcription",
        "Basic sentiment analysis",
        "Email support",
        "1 team member",
        "Basic analytics"
      ],
      recommended: false
    },
    {
      name: "Professional",
      price: "$199",
      perCall: "$0.06",
      limit: "5,000 calls/month",
      features: [
        "Up to 5,000 calls per month",
        "Advanced transcription",
        "Deep sentiment analysis",
        "Priority support",
        "10 team members",
        "Advanced analytics",
        "API access",
        "Webhook integrations"
      ],
      recommended: true
    },
    {
      name: "Enterprise",
      price: "$499",
      perCall: "$0.04",
      limit: "Unlimited calls",
      features: [
        "Unlimited calls",
        "Premium transcription",
        "AI-powered insights",
        "24/7 dedicated support",
        "Unlimited team members",
        "Custom analytics",
        "Full API access",
        "Custom webhooks",
        "SSO/SAML",
        "Custom SLA"
      ],
      recommended: false
    }
  ];

  return (
    <PublicLayout>
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div className="text-center mb-16">
          <h1 className="text-4xl lg:text-5xl font-bold mb-4">
            Simple,{" "}
            <span className="bg-gradient-to-r from-indigo-400 to-cyan-400 bg-clip-text text-transparent">
              Transparent
            </span>{" "}
            Pricing
          </h1>
          <p className="text-xl text-muted-foreground max-w-3xl mx-auto">
            Pay only for what you use. All plans include a 14-day free trial with no credit card required.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-3 gap-8 mb-16">
          {plans.map((plan, index) => (
            <Card
              key={index}
              className={`relative ${plan.recommended ? 'border-indigo-600/50 shadow-lg shadow-indigo-600/10' : ''}`}
              data-testid={`card-plan-${index}`}
            >
              {plan.recommended && (
                <div className="absolute -top-4 left-1/2 -translate-x-1/2">
                  <Badge className="bg-gradient-to-r from-indigo-600 to-cyan-600 border-none" data-testid="badge-recommended">
                    Recommended
                  </Badge>
                </div>
              )}
              <CardHeader>
                <CardTitle className="text-2xl">{plan.name}</CardTitle>
                <CardDescription>
                  <div className="mt-4">
                    <span className="text-4xl font-bold text-foreground">{plan.price}</span>
                    <span className="text-muted-foreground">/month</span>
                  </div>
                  <div className="mt-2 text-sm">
                    {plan.perCall} per call • {plan.limit}
                  </div>
                </CardDescription>
              </CardHeader>
              <CardContent>
                <ul className="space-y-3">
                  {plan.features.map((feature, featureIndex) => (
                    <li key={featureIndex} className="flex items-start gap-2">
                      <Check className="w-5 h-5 text-indigo-400 shrink-0 mt-0.5" />
                      <span className="text-sm">{feature}</span>
                    </li>
                  ))}
                </ul>
              </CardContent>
              <CardFooter>
                <Link href="/register" className="w-full">
                  <Button
                    className={`w-full ${plan.recommended ? 'bg-gradient-to-r from-indigo-600 to-cyan-600 hover:from-indigo-500 hover:to-cyan-500' : ''}`}
                    variant={plan.recommended ? 'default' : 'outline'}
                    data-testid={`button-select-${index}`}
                  >
                    Get Started
                  </Button>
                </Link>
              </CardFooter>
            </Card>
          ))}
        </div>

        <div className="text-center">
          <p className="text-muted-foreground mb-4">
            Need a custom plan? We can work with you.
          </p>
          <Link href="/contact">
            <Button variant="outline" size="lg" data-testid="button-contact-sales">
              Contact Sales
            </Button>
          </Link>
        </div>
      </div>
    </PublicLayout>
  );
}
