import { Link } from "wouter";
import PublicLayout from "@/components/PublicLayout";
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { Phone, Shield, BarChart3, Users, Zap, Globe, TrendingUp, Clock, MessageSquare } from "lucide-react";

export default function Home() {
  const features = [
    {
      icon: Phone,
      title: "AI Voice Processing",
      description: "Advanced voice recognition and natural conversation handling with real-time transcription."
    },
    {
      icon: Shield,
      title: "Enterprise Security",
      description: "Multi-tenant architecture with row-level security and WCAG 2.1 AA compliance."
    },
    {
      icon: BarChart3,
      title: "Real-time Analytics",
      description: "Comprehensive dashboards with sentiment analysis and performance metrics."
    },
    {
      icon: Users,
      title: "Team Management",
      description: "Role-based access control for admins, agents, and billing managers."
    },
    {
      icon: Zap,
      title: "Instant Simulation",
      description: "Test scenarios across banking, healthcare, retail, and insurance industries."
    },
    {
      icon: Globe,
      title: "Global Scale",
      description: "Built to handle millions of calls with automatic billing and webhooks."
    }
  ];

  return (
    <PublicLayout>
      <div className="relative overflow-hidden">
        <div className="absolute inset-0 bg-gradient-to-br from-indigo-600/20 via-transparent to-cyan-600/20 pointer-events-none" />
        
        <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-24 lg:py-32">
          <div className="text-center max-w-4xl mx-auto">
            <Badge className="mb-4 bg-indigo-600/10 text-indigo-400 border-indigo-600/20" data-testid="badge-new">
              Now with Real-time Sentiment Analysis
            </Badge>
            <h1 className="text-5xl lg:text-6xl font-bold tracking-tight mb-6">
              AI Voice Assistant for{" "}
              <span className="bg-gradient-to-r from-indigo-400 to-cyan-400 bg-clip-text text-transparent">
                Enterprise
              </span>
            </h1>
            <p className="text-xl text-muted-foreground mb-8 max-w-2xl mx-auto">
              Transform customer interactions with AI-powered voice assistants. Built for banks, call centers, fintech, healthcare, telecom, and insurance.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Link href="/register">
                <Button size="lg" className="bg-gradient-to-r from-indigo-600 to-cyan-600 hover:from-indigo-500 hover:to-cyan-500 text-lg px-8" data-testid="button-start-trial">
                  Start Free Trial
                </Button>
              </Link>
              <Link href="/contact">
                <Button size="lg" variant="outline" className="text-lg px-8" data-testid="button-schedule-demo">
                  Schedule Demo
                </Button>
              </Link>
            </div>

            <div className="mt-16 grid grid-cols-1 sm:grid-cols-3 gap-8 text-center">
              <div>
                <div className="flex items-center justify-center gap-2 mb-2">
                  <TrendingUp className="w-5 h-5 text-indigo-400" />
                  <div className="text-3xl font-bold" data-testid="stat-calls">2.4M+</div>
                </div>
                <div className="text-sm text-muted-foreground">Calls Processed</div>
              </div>
              <div>
                <div className="flex items-center justify-center gap-2 mb-2">
                  <Users className="w-5 h-5 text-cyan-400" />
                  <div className="text-3xl font-bold" data-testid="stat-tenants">500+</div>
                </div>
                <div className="text-sm text-muted-foreground">Enterprise Clients</div>
              </div>
              <div>
                <div className="flex items-center justify-center gap-2 mb-2">
                  <Clock className="w-5 h-5 text-indigo-400" />
                  <div className="text-3xl font-bold" data-testid="stat-uptime">99.9%</div>
                </div>
                <div className="text-sm text-muted-foreground">Uptime SLA</div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-24">
        <div className="text-center mb-16">
          <h2 className="text-3xl lg:text-4xl font-bold mb-4">
            Everything you need to power AI voice interactions
          </h2>
          <p className="text-xl text-muted-foreground max-w-2xl mx-auto">
            A complete platform with real-time analytics, sentiment analysis, and automatic billing.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
          {features.map((feature, index) => (
            <Card key={index} className="hover-elevate" data-testid={`card-feature-${index}`}>
              <CardHeader>
                <div className="w-12 h-12 rounded-md bg-gradient-to-br from-indigo-600/20 to-cyan-600/20 flex items-center justify-center mb-4">
                  <feature.icon className="w-6 h-6 text-indigo-400" />
                </div>
                <CardTitle>{feature.title}</CardTitle>
              </CardHeader>
              <CardContent>
                <CardDescription>{feature.description}</CardDescription>
              </CardContent>
            </Card>
          ))}
        </div>
      </div>

      <div className="bg-gradient-to-br from-indigo-600/10 via-background to-cyan-600/10 py-24">
        <div className="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <MessageSquare className="w-16 h-16 text-indigo-400 mx-auto mb-6" />
          <h2 className="text-3xl lg:text-4xl font-bold mb-6">
            Ready to transform your customer interactions?
          </h2>
          <p className="text-xl text-muted-foreground mb-8 max-w-2xl mx-auto">
            Join hundreds of enterprises using Zyvra to handle millions of calls with AI precision.
          </p>
          <Link href="/register">
            <Button size="lg" className="bg-gradient-to-r from-indigo-600 to-cyan-600 hover:from-indigo-500 hover:to-cyan-500 text-lg px-8" data-testid="button-get-started">
              Get Started Now
            </Button>
          </Link>
        </div>
      </div>
    </PublicLayout>
  );
}
