import PublicLayout from "@/components/PublicLayout";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Phone, Shield, BarChart3, Users, Zap, Globe, Database, Webhook, Lock, TrendingUp, Clock, MessageSquare } from "lucide-react";

export default function Features() {
  const featureSections = [
    {
      category: "Voice Intelligence",
      icon: Phone,
      features: [
        { name: "Real-time Transcription", description: "Instant speech-to-text conversion with 95%+ accuracy" },
        { name: "Sentiment Analysis", description: "AI-powered emotion detection and confidence scoring" },
        { name: "Natural Conversations", description: "Context-aware responses with human-like interaction" },
        { name: "Multi-language Support", description: "Handle calls in 50+ languages automatically" }
      ]
    },
    {
      category: "Enterprise Security",
      icon: Shield,
      features: [
        { name: "Multi-tenant Architecture", description: "Complete data isolation with row-level security" },
        { name: "Role-based Access", description: "Granular permissions for admins, agents, and managers" },
        { name: "Audit Logging", description: "Comprehensive system logs for compliance" },
        { name: "WCAG 2.1 AA Compliant", description: "Accessible design for all users" }
      ]
    },
    {
      category: "Analytics & Insights",
      icon: BarChart3,
      features: [
        { name: "Real-time Dashboards", description: "Live metrics with auto-refresh and time filters" },
        { name: "Performance Metrics", description: "Track success rate, duration, and escalation" },
        { name: "Industry Benchmarks", description: "Compare performance across sectors" },
        { name: "Custom Reports", description: "Export and analyze historical data" }
      ]
    },
    {
      category: "Team Collaboration",
      icon: Users,
      features: [
        { name: "Member Management", description: "Invite, assign roles, and manage team access" },
        { name: "Knowledge Base", description: "Centralized documentation and resources" },
        { name: "API Keys", description: "Secure credential management with regeneration" },
        { name: "Webhooks", description: "Real-time event notifications for integrations" }
      ]
    },
    {
      category: "Automation",
      icon: Zap,
      features: [
        { name: "Scenario Simulation", description: "Test banking, healthcare, retail, and insurance flows" },
        { name: "Automatic Billing", description: "Per-call pricing with usage tracking" },
        { name: "Call Recording", description: "Store, play, and download call records" },
        { name: "Invoice Generation", description: "Automated billing with plan-based pricing" }
      ]
    },
    {
      category: "Scalability",
      icon: Globe,
      features: [
        { name: "WebSocket Support", description: "Real-time updates with load balancing" },
        { name: "PostgreSQL Backend", description: "Enterprise-grade database with RLS" },
        { name: "Stripe Integration", description: "Secure payment processing and subscriptions" },
        { name: "99.9% Uptime", description: "Reliable infrastructure with auto-scaling" }
      ]
    }
  ];

  return (
    <PublicLayout>
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-16">
        <div className="text-center mb-16">
          <h1 className="text-4xl lg:text-5xl font-bold mb-4">
            Platform{" "}
            <span className="bg-gradient-to-r from-indigo-400 to-cyan-400 bg-clip-text text-transparent">
              Features
            </span>
          </h1>
          <p className="text-xl text-muted-foreground max-w-3xl mx-auto">
            A comprehensive AI voice assistant platform built for enterprise needs. Everything you need to handle millions of customer interactions.
          </p>
        </div>

        <div className="space-y-12">
          {featureSections.map((section, sectionIndex) => (
            <div key={sectionIndex}>
              <div className="flex items-center gap-3 mb-6">
                <div className="w-10 h-10 rounded-md bg-gradient-to-br from-indigo-600/20 to-cyan-600/20 flex items-center justify-center">
                  <section.icon className="w-6 h-6 text-indigo-400" />
                </div>
                <h2 className="text-2xl font-bold">{section.category}</h2>
              </div>
              <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
                {section.features.map((feature, featureIndex) => (
                  <Card key={featureIndex} data-testid={`card-feature-${sectionIndex}-${featureIndex}`}>
                    <CardHeader>
                      <CardTitle className="text-lg">{feature.name}</CardTitle>
                    </CardHeader>
                    <CardContent>
                      <CardDescription>{feature.description}</CardDescription>
                    </CardContent>
                  </Card>
                ))}
              </div>
            </div>
          ))}
        </div>
      </div>
    </PublicLayout>
  );
}
