import { useLocation } from "wouter";
import PublicLayout from "@/components/PublicLayout";
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { AudioWaveform } from "lucide-react";

export default function DemoLogin() {
  const [, setLocation] = useLocation();

  const demoAccounts = [
    {
      role: "Client Admin",
      email: "admin@acme.com",
      description: "Full access to client dashboard, team management, settings",
      route: "/client/dashboard"
    },
    {
      role: "Agent",
      email: "agent@acme.com",
      description: "Access to calls, simulation, and analytics",
      route: "/client/dashboard"
    },
    {
      role: "Billing Manager",
      email: "billing@acme.com",
      description: "Access to billing and usage information",
      route: "/client/billing"
    },
    {
      role: "Super Admin",
      email: "superadmin@zyvra.com",
      description: "Platform-wide administration and monitoring",
      route: "/admin/dashboard"
    }
  ];

  return (
    <PublicLayout>
      <div className="min-h-[80vh] flex items-center justify-center px-4">
        <Card className="w-full max-w-3xl">
          <CardHeader className="space-y-1">
            <div className="flex justify-center mb-4">
              <div className="w-12 h-12 rounded-md bg-gradient-to-br from-indigo-600 to-cyan-600 flex items-center justify-center">
                <AudioWaveform className="w-6 h-6 text-white" />
              </div>
            </div>
            <CardTitle className="text-2xl text-center">Demo Accounts</CardTitle>
            <CardDescription className="text-center">
              Select an account type to explore different dashboard views
            </CardDescription>
          </CardHeader>
          <CardContent>
            <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
              {demoAccounts.map((account, index) => (
                <Card key={index} className="hover-elevate cursor-pointer" onClick={() => setLocation(account.route)} data-testid={`demo-${index}`}>
                  <CardHeader>
                    <CardTitle className="text-lg">{account.role}</CardTitle>
                    <CardDescription className="text-sm">{account.email}</CardDescription>
                  </CardHeader>
                  <CardContent>
                    <p className="text-sm text-muted-foreground mb-4">{account.description}</p>
                    <Button className="w-full bg-gradient-to-r from-indigo-600 to-cyan-600 hover:from-indigo-500 hover:to-cyan-500">
                      Login as {account.role}
                    </Button>
                  </CardContent>
                </Card>
              ))}
            </div>
          </CardContent>
        </Card>
      </div>
    </PublicLayout>
  );
}
