import { Link } from "wouter";
import { Button } from "@/components/ui/button";
import { AudioWaveform, Menu, X } from "lucide-react";
import { useState } from "react";

export default function PublicLayout({ children }: { children: React.ReactNode }) {
  const [mobileMenuOpen, setMobileMenuOpen] = useState(false);

  return (
    <div className="min-h-screen bg-background">
      <nav className="border-b border-border bg-card/50 backdrop-blur-sm sticky top-0 z-50">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="flex justify-between items-center h-16">
            <Link href="/" data-testid="link-home">
              <div className="flex items-center gap-3 hover-elevate px-3 py-2 rounded-md -ml-3">
                <div className="w-8 h-8 rounded-md bg-gradient-to-br from-indigo-600 to-cyan-600 flex items-center justify-center">
                  <AudioWaveform className="w-5 h-5 text-white" />
                </div>
                <span className="text-xl font-bold">Zyvra</span>
              </div>
            </Link>

            <div className="hidden md:flex items-center gap-1">
              <Link href="/features">
                <Button variant="ghost" size="sm" data-testid="link-features">Features</Button>
              </Link>
              <Link href="/pricing">
                <Button variant="ghost" size="sm" data-testid="link-pricing">Pricing</Button>
              </Link>
              <Link href="/docs">
                <Button variant="ghost" size="sm" data-testid="link-docs">Docs</Button>
              </Link>
              <Link href="/contact">
                <Button variant="ghost" size="sm" data-testid="link-contact">Contact</Button>
              </Link>
            </div>

            <div className="hidden md:flex items-center gap-3">
              <Link href="/login">
                <Button variant="ghost" size="sm" data-testid="button-login">Log in</Button>
              </Link>
              <Link href="/register">
                <Button className="bg-gradient-to-r from-indigo-600 to-cyan-600 hover:from-indigo-500 hover:to-cyan-500" size="sm" data-testid="button-signup">
                  Start Free Trial
                </Button>
              </Link>
            </div>

            <Button
              variant="ghost"
              size="icon"
              className="md:hidden"
              onClick={() => setMobileMenuOpen(!mobileMenuOpen)}
              data-testid="button-menu-toggle"
            >
              {mobileMenuOpen ? <X className="w-5 h-5" /> : <Menu className="w-5 h-5" />}
            </Button>
          </div>
        </div>

        {mobileMenuOpen && (
          <div className="md:hidden border-t border-border bg-card/95 backdrop-blur-sm">
            <div className="px-4 py-4 space-y-2">
              <Link href="/features">
                <Button variant="ghost" className="w-full justify-start" data-testid="link-features-mobile">Features</Button>
              </Link>
              <Link href="/pricing">
                <Button variant="ghost" className="w-full justify-start" data-testid="link-pricing-mobile">Pricing</Button>
              </Link>
              <Link href="/docs">
                <Button variant="ghost" className="w-full justify-start" data-testid="link-docs-mobile">Docs</Button>
              </Link>
              <Link href="/contact">
                <Button variant="ghost" className="w-full justify-start" data-testid="link-contact-mobile">Contact</Button>
              </Link>
              <div className="pt-2 border-t border-border space-y-2">
                <Link href="/login">
                  <Button variant="ghost" className="w-full justify-start" data-testid="button-login-mobile">Log in</Button>
                </Link>
                <Link href="/register">
                  <Button className="w-full bg-gradient-to-r from-indigo-600 to-cyan-600" data-testid="button-signup-mobile">
                    Start Free Trial
                  </Button>
                </Link>
              </div>
            </div>
          </div>
        )}
      </nav>

      {children}

      <footer className="border-t border-border bg-card/30 backdrop-blur-sm mt-24">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
          <div className="grid grid-cols-1 md:grid-cols-4 gap-8">
            <div>
              <div className="flex items-center gap-3 mb-4">
                <div className="w-8 h-8 rounded-md bg-gradient-to-br from-indigo-600 to-cyan-600 flex items-center justify-center">
                  <AudioWaveform className="w-5 h-5 text-white" />
                </div>
                <span className="text-xl font-bold">Zyvra</span>
              </div>
              <p className="text-sm text-muted-foreground">
                Enterprise AI voice assistant platform for modern businesses.
              </p>
            </div>
            <div>
              <h4 className="font-semibold mb-4">Product</h4>
              <ul className="space-y-2 text-sm text-muted-foreground">
                <li><Link href="/features"><span className="hover:text-foreground">Features</span></Link></li>
                <li><Link href="/pricing"><span className="hover:text-foreground">Pricing</span></Link></li>
                <li><Link href="/docs"><span className="hover:text-foreground">Documentation</span></Link></li>
              </ul>
            </div>
            <div>
              <h4 className="font-semibold mb-4">Company</h4>
              <ul className="space-y-2 text-sm text-muted-foreground">
                <li><Link href="/contact"><span className="hover:text-foreground">Contact</span></Link></li>
              </ul>
            </div>
            <div>
              <h4 className="font-semibold mb-4">Legal</h4>
              <ul className="space-y-2 text-sm text-muted-foreground">
                <li><span className="hover:text-foreground cursor-pointer">Privacy</span></li>
                <li><span className="hover:text-foreground cursor-pointer">Terms</span></li>
              </ul>
            </div>
          </div>
          <div className="border-t border-border mt-8 pt-8 text-center text-sm text-muted-foreground">
            © {new Date().getFullYear()} Zyvra. All rights reserved.
          </div>
        </div>
      </footer>
    </div>
  );
}
