import { SidebarProvider, SidebarTrigger } from "@/components/ui/sidebar";
import AppSidebar from "@/components/AppSidebar";

interface DashboardLayoutProps {
  children: React.ReactNode;
  userRole?: "superadmin" | "tenant_admin" | "agent" | "billing_manager";
  tenantName?: string;
  pageTitle?: string;
}

export default function DashboardLayout({ children, userRole = "tenant_admin", tenantName = "Acme Inc.", pageTitle }: DashboardLayoutProps) {
  const style = {
    "--sidebar-width": "16rem",
    "--sidebar-width-icon": "3rem",
  };

  return (
    <SidebarProvider style={style as React.CSSProperties}>
      <div className="flex h-screen w-full">
        <AppSidebar userRole={userRole} tenantName={tenantName} />
        <div className="flex flex-col flex-1 overflow-hidden">
          <header className="flex items-center gap-4 border-b border-border bg-card/50 backdrop-blur-sm px-6 py-3 sticky top-0 z-40">
            <SidebarTrigger data-testid="button-sidebar-toggle" />
            {pageTitle && <h1 className="text-xl font-bold">{pageTitle}</h1>}
          </header>
          <main className="flex-1 overflow-auto p-6">
            {children}
          </main>
        </div>
      </div>
    </SidebarProvider>
  );
}
