import { Home, Phone, BarChart3, Users, Settings, Shield, Calendar, Zap, DollarSign, Key, BookOpen, LogOut, AudioWaveform } from "lucide-react";
import { Link, useLocation } from "wouter";
import {
  Sidebar,
  SidebarContent,
  SidebarGroup,
  SidebarGroupContent,
  SidebarGroupLabel,
  SidebarMenu,
  SidebarMenuButton,
  SidebarMenuItem,
  SidebarHeader,
  SidebarFooter
} from "@/components/ui/sidebar";
import { Avatar, AvatarFallback } from "@/components/ui/avatar";
import { Badge } from "@/components/ui/badge";

interface AppSidebarProps {
  userRole?: "superadmin" | "tenant_admin" | "agent" | "billing_manager";
  tenantName?: string;
}

export default function AppSidebar({ userRole = "tenant_admin", tenantName = "Acme Inc." }: AppSidebarProps) {
  const [location] = useLocation();

  const clientMenuItems = [
    { title: "Dashboard", url: "/client/dashboard", icon: Home },
    { title: "Live Calls", url: "/client/live-calls", icon: Phone },
    { title: "Call History", url: "/client/call-history", icon: Calendar },
    { title: "Simulation", url: "/client/simulation", icon: Zap },
    { title: "Analytics", url: "/client/analytics", icon: BarChart3 },
    { title: "Team", url: "/client/team", icon: Users },
    { title: "Billing", url: "/client/billing", icon: DollarSign },
    { title: "Settings", url: "/client/settings", icon: Settings },
  ];

  const adminMenuItems = [
    { title: "Dashboard", url: "/admin/dashboard", icon: Home },
    { title: "Tenants", url: "/admin/tenants", icon: Shield },
    { title: "Users", url: "/admin/users", icon: Users },
    { title: "Analytics", url: "/admin/analytics", icon: BarChart3 },
    { title: "System Logs", url: "/admin/logs", icon: BookOpen },
  ];

  const menuItems = userRole === "superadmin" ? adminMenuItems : clientMenuItems;

  return (
    <Sidebar>
      <SidebarHeader className="p-4">
        <div className="flex items-center gap-3">
          <div className="w-8 h-8 rounded-md bg-gradient-to-br from-indigo-600 to-cyan-600 flex items-center justify-center">
            <AudioWaveform className="w-5 h-5 text-white" />
          </div>
          <div>
            <div className="text-sm font-bold">Zyvra</div>
            {userRole !== "superadmin" && (
              <div className="text-xs text-muted-foreground">{tenantName}</div>
            )}
          </div>
        </div>
      </SidebarHeader>

      <SidebarContent>
        <SidebarGroup>
          <SidebarGroupLabel>{userRole === "superadmin" ? "Admin" : "Application"}</SidebarGroupLabel>
          <SidebarGroupContent>
            <SidebarMenu>
              {menuItems.map((item) => (
                <SidebarMenuItem key={item.title}>
                  <SidebarMenuButton asChild isActive={location === item.url}>
                    <Link href={item.url} data-testid={`link-${item.title.toLowerCase().replace(/\s+/g, '-')}`}>
                      <item.icon className="w-4 h-4" />
                      <span>{item.title}</span>
                    </Link>
                  </SidebarMenuButton>
                </SidebarMenuItem>
              ))}
            </SidebarMenu>
          </SidebarGroupContent>
        </SidebarGroup>
      </SidebarContent>

      <SidebarFooter className="p-4">
        <div className="flex items-center gap-3 p-2 rounded-md hover-elevate cursor-pointer" data-testid="button-user-menu">
          <Avatar className="w-8 h-8">
            <AvatarFallback className="bg-gradient-to-br from-indigo-600 to-cyan-600 text-white text-sm">
              JD
            </AvatarFallback>
          </Avatar>
          <div className="flex-1 min-w-0">
            <div className="text-sm font-medium truncate">John Doe</div>
            <div className="text-xs text-muted-foreground truncate">john@acme.com</div>
          </div>
        </div>
      </SidebarFooter>
    </Sidebar>
  );
}
