import { Switch, Route } from "wouter";
import { queryClient } from "./lib/queryClient";
import { QueryClientProvider } from "@tanstack/react-query";
import { Toaster } from "@/components/ui/toaster";
import { TooltipProvider } from "@/components/ui/tooltip";
import NotFound from "@/pages/not-found";

import Home from "@/pages/Home";
import Features from "@/pages/Features";
import Pricing from "@/pages/Pricing";
import Contact from "@/pages/Contact";
import Docs from "@/pages/Docs";
import Login from "@/pages/Login";
import Register from "@/pages/Register";
import DemoLogin from "@/pages/DemoLogin";
import ClientDashboard from "@/pages/ClientDashboard";
import AdminDashboard from "@/pages/AdminDashboard";
import Simulation from "@/pages/Simulation";
import CallHistory from "@/pages/CallHistory";
import LiveCalls from "@/pages/LiveCalls";
import Billing from "@/pages/Billing";
import Settings from "@/pages/Settings";
import Team from "@/pages/Team";
import Analytics from "@/pages/Analytics";

function Router() {
  return (
    <Switch>
      <Route path="/" component={Home} />
      <Route path="/features" component={Features} />
      <Route path="/pricing" component={Pricing} />
      <Route path="/contact" component={Contact} />
      <Route path="/docs" component={Docs} />
      <Route path="/login" component={Login} />
      <Route path="/register" component={Register} />
      <Route path="/demo" component={DemoLogin} />
      
      <Route path="/client/dashboard" component={ClientDashboard} />
      <Route path="/client/simulation" component={Simulation} />
      <Route path="/client/call-history" component={CallHistory} />
      <Route path="/client/live-calls" component={LiveCalls} />
      <Route path="/client/billing" component={Billing} />
      <Route path="/client/analytics" component={Analytics} />
      <Route path="/client/team" component={Team} />
      <Route path="/client/settings" component={Settings} />
      
      <Route path="/admin/dashboard" component={AdminDashboard} />
      
      <Route component={NotFound} />
    </Switch>
  );
}

export default function App() {
  return (
    <QueryClientProvider client={queryClient}>
      <TooltipProvider>
        <Toaster />
        <Router />
      </TooltipProvider>
    </QueryClientProvider>
  );
}
